/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final String STR_NEWLINE = String.format("%n", new Object[0]);

    public static void main(String[] args) {
        int i;
        String STR_SAMPLE_CHATLOG = ".--------------------------------------------------------------------." + STR_NEWLINE + "| Session Start: 26 February 2004                                    |" + STR_NEWLINE + "| Participants:                                                      |" + STR_NEWLINE + "|    My user name :) ): (here's some text.) :( :) _- _ ?! qaw :! :() (localhost@hotmail.com)                           |" + STR_NEWLINE + "|    nospam@nospam.com (remotehost@hotmail.com)                     |" + STR_NEWLINE + ".--------------------------------------------------------------------." + STR_NEWLINE + "[16:44:33] My user name: Hello there" + STR_NEWLINE + "[16:45:02] Recipient's : hi" + STR_NEWLINE + "[16:45:49] My user name: How are you?" + STR_NEWLINE + "[16:46:37] Recipient's : I'm ok" + STR_NEWLINE + "[16:46:38] Recipient's : yourself?" + "";
        String strInput = null;
        if (args == null || args.length == 0) {
            strInput = STR_SAMPLE_CHATLOG;
        } else {
            try {
                strInput = Main.readTextFile(new File(args[0]));
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
        String strHeader = "";
        String strContent = "";
        String[] strArraySplit = strInput.split("\n");
        ArrayList<String> alistHeader = new ArrayList<String>();
        ArrayList<String> alistContent = new ArrayList<String>();
        int intNumberOfContacts = 0;
        Contact[] contactsArray = null;
        Pattern patternSessionStartDate = Pattern.compile("(\\d{1,2})[ -]([\\dA-Za-z]+)[ -](\\d{2,4})");
        Pattern patternTimestamp = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}");
        Pattern patternHeaderContactName = Pattern.compile("\\b(.+)(?=.+\\([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)");
        Pattern patternHeaderContactEmail = Pattern.compile("(\\()([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)(\\))");
        Matcher matcher = null;
        SimpleDateFormat dfDayMonthYear = new SimpleDateFormat("dd MMMMM yyyy");
        SimpleDateFormat dfDayMonthYearTime = new SimpleDateFormat("dd MMMMM yyyy HH:mm:ss");
        SimpleDateFormat dfYearMonthDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dfYearMonthDayTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dfTimestamp = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat dfFilename = new SimpleDateFormat("yyyy-MM-dd.HHmmss");
        Date dateSessionStart = null;
        String strSessionStartDate = null;
        String strSessionStartTime = null;
        int INT_LINES_IN_HEADER = Main.getLastHeaderLine(strArraySplit) + 1;
        int INT_FIRST_CONTACT_LINE = Main.getFirstHeaderContactLine(strArraySplit);
        int INT_TIMESTAMP_LENGTH = Main.getTimestampLength(strArraySplit, INT_LINES_IN_HEADER);
        for (i = 0; i < INT_LINES_IN_HEADER; ++i) {
            alistHeader.add(strArraySplit[i]);
            strHeader = strHeader + strArraySplit[i] + (i != INT_LINES_IN_HEADER - 1 ? STR_NEWLINE : "");
        }
        for (i = INT_LINES_IN_HEADER; i < strArraySplit.length; ++i) {
            alistContent.add(strArraySplit[i]);
            strContent = strContent + strArraySplit[i] + (i != strArraySplit.length - 1 ? STR_NEWLINE : "");
        }
        Main.printArrayList(alistHeader);
        matcher = patternSessionStartDate.matcher((CharSequence)alistHeader.get(1));
        if (matcher.find()) {
            strSessionStartDate = matcher.group(0);
        } else {
            System.out.println("\"Session Start\" date not found in header.");
        }
        matcher = patternHeaderContactEmail.matcher(strHeader);
        while (matcher.find()) {
            ++intNumberOfContacts;
        }
        Main.println("Number of Contacts: " + intNumberOfContacts);
        contactsArray = new Contact[intNumberOfContacts];
        for (i = 0; i < contactsArray.length; ++i) {
            contactsArray[i] = new Contact();
            matcher = patternHeaderContactName.matcher((CharSequence)alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find()) {
                contactsArray[i].setName(matcher.group(0));
            } else {
                System.out.println("Name not found in header.");
            }
            matcher = patternHeaderContactEmail.matcher((CharSequence)alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find() && matcher.groupCount() == 3) {
                contactsArray[i].setEmail(matcher.group(2));
            } else {
                System.out.println("Email not found in header.");
            }
            System.out.println("Contact " + (i + 1) + ":");
            System.out.println("\tName: " + contactsArray[i].getName());
            System.out.println("\tEmail: " + contactsArray[i].getEmail());
            System.out.println();
        }
        matcher = patternTimestamp.matcher((CharSequence)alistContent.get(0));
        if (matcher.find()) {
            strSessionStartTime = matcher.group(0);
            try {
                dateSessionStart = dfDayMonthYearTime.parse(strSessionStartDate + " " + strSessionStartTime);
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        } else {
            System.out.println("First timestamp not found in chatlog.");
        }
        ArrayList<Date> alistContactTimestamp = new ArrayList<Date>();
        ArrayList<String> alistContactName = new ArrayList<String>();
        ArrayList<String> alistContactMessage = new ArrayList<String>();
        String[] strArrayContent = null;
        String strContactTimestamp = "";
        for (int i2 = 0; i2 < alistContent.size(); ++i2) {
            matcher = patternTimestamp.matcher((CharSequence)alistContent.get(i2));
            if (matcher.find()) {
                strContactTimestamp = matcher.group(0);
                try {
                    Date dateTimestamp = dfTimestamp.parse(strContactTimestamp);
                    alistContactTimestamp.add(dateTimestamp);
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            } else {
                System.out.println("Timestamp not found in chatlog content line " + (i2 + 1) + ".");
            }
            strArrayContent = ((String)alistContent.get(i2)).substring(INT_TIMESTAMP_LENGTH).split(": ", 2);
            alistContactName.add(strArrayContent[0]);
            alistContactMessage.add(strArrayContent[1]);
        }
        String strOutput = "";
        strOutput = strOutput + "<html><head><title>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</title></head><body><h3>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</h3>";
        if (alistContactTimestamp.size() == alistContactName.size() && alistContactTimestamp.size() == alistContactMessage.size()) {
            for (int i3 = 0; i3 < alistContactTimestamp.size(); ++i3) {
                strOutput = strOutput + STR_NEWLINE;
                strOutput = contactsArray[0].getName().startsWith((String)alistContactName.get(i3)) ? strOutput + "<font color=\"#16569E\"><font size=\"2\">(" + dfTimestamp.format((Date)alistContactTimestamp.get(i3)) + ")</font> <b>" + (String)alistContactName.get(i3) + ":</b></font> <font sml=\"MSN\">" + (String)alistContactMessage.get(i3) + "</font><br/>" : strOutput + "<font color=\"#A82F2F\"><font size=\"2\">(" + dfTimestamp.format((Date)alistContactTimestamp.get(i3)) + ")</font> <b>" + (String)alistContactName.get(i3) + ":</b></font> <font sml=\"MSN\"><span style=\"font-family: High Tower Text;\"><strong><span style=\"color: #ff0000;\">" + (String)alistContactMessage.get(i3) + "</span></strong></span></font><br/>";
            }
            strOutput = strOutput + "</body></html>";
        } else {
            System.out.println("Contact timestamp, name, and message do not match.");
        }
        File currentDirectory = null;
        File folderPath = null;
        String strFoldername = contactsArray[1].getEmail();
        String strFilename = dfFilename.format(dateSessionStart) + ".html";
        try {
            currentDirectory = new File(".");
            folderPath = new File(currentDirectory.getCanonicalPath() + File.separator + strFoldername);
            folderPath.mkdirs();
            Main.writeTextFile(folderPath.getPath() + File.separator + strFilename, strOutput);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
    }

    private static String retrieveInput(String strInputText) {
        Scanner scannerInput = new Scanner(System.in);
        System.out.print(strInputText);
        return scannerInput.nextLine();
    }

    private static int getLastHeaderLine(String[] strArrayChatlog) {
        for (int i = 1; i < strArrayChatlog.length; ++i) {
            if (!strArrayChatlog[i].startsWith(".---------------------------------")) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstHeaderContactLine(String[] strArrayChatlog) {
        for (int i = 1; i < strArrayChatlog.length; ++i) {
            if (!strArrayChatlog[i].startsWith("| Participants:")) continue;
            return i + 1;
        }
        return -1;
    }

    private static int getTimestampLength(String[] strArrayChatlog, int intFirstContentLine) {
        Pattern patternTimestamp = Pattern.compile("(\\W)([0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2})(\\W\\s)");
        Matcher matcher = patternTimestamp.matcher(strArrayChatlog[intFirstContentLine]);
        if (matcher.find()) {
            return matcher.end();
        }
        System.out.println("First timestamp not found in content.");
        return -1;
    }

    private static String[] omitEmptyStrings(String[] strArray) {
        ArrayList<String> alistTemporary = new ArrayList<String>();
        for (String str : strArray) {
            if (str.equals("")) continue;
            alistTemporary.add(str);
        }
        strArray = new String[]{};
        return alistTemporary.toArray(strArray);
    }

    private static String[] omitWhitespace(String[] strArray) {
        ArrayList<String> alistTemporary = new ArrayList<String>();
        for (String str : strArray) {
            if (str.trim().length() == 0) continue;
            alistTemporary.add(str);
        }
        strArray = new String[]{};
        return alistTemporary.toArray(strArray);
    }

    private static boolean isInteger(String strInput) {
        try {
            Integer.parseInt(strInput);
            return true;
        }
        catch (NumberFormatException exNumberFormat) {
            return false;
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private static boolean isNumber(String strInput) {
        try {
            Double.parseDouble(strInput);
            return true;
        }
        catch (NumberFormatException exNumberFormat) {
            return false;
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private static void print(Object objPrint) {
        System.out.print(objPrint.toString());
    }

    private static void println(Object objPrint) {
        System.out.println(objPrint.toString());
    }

    private static void printArray(Object[] objArray) {
        for (Object obj : objArray) {
            System.out.println(obj.toString());
        }
    }

    private static void printArrayList(ArrayList alistArray) {
        for (Object obj : alistArray) {
            System.out.println(obj.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTextFile(File file) throws Exception {
        Scanner scanner = null;
        String strFileContent = "";
        try {
            scanner = new Scanner(file, "UTF-8");
            while (scanner.hasNextLine()) {
                strFileContent = strFileContent + scanner.nextLine() + STR_NEWLINE;
            }
        }
        catch (IOException exIO) {
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
        return strFileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextFile(String strFilename, String strFileContent) {
        Writer writerTextFile = null;
        try {
            writerTextFile = new OutputStreamWriter((OutputStream)new FileOutputStream(strFilename), "UTF-8");
            writerTextFile.write(strFileContent);
        }
        catch (IOException exIO) {
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally {
            try {
                writerTextFile.close();
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
    }
}

