/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final String STR_NEWLINE = String.format("%n", new Object[0]);
    private static final String STR_STATUS_ACTION_HASH = "4114CCE4E51FDFCEA5D7022BF08CD2D1E3EE73B7A6E818A2F5623C3A0B79A396278313F52E50489EFB8C6B04CCA1FC0D082009DFB5120F0290C53A840142CAE2";

    public static void main(String[] args) throws Exception {
        int i;
        Main.setOutEncoding();
        String STR_SAMPLE_CHATLOG = ".--------------------------------------------------------------------." + STR_NEWLINE + "| Session Start: 26 February 2004                                    |" + STR_NEWLINE + "| Participants:                                                      |" + STR_NEWLINE + "|    My user name :) ): (here's some text.) :( :) _- _ ?! qaw :! :() (localhost@hotmail.com)                           |" + STR_NEWLINE + "|    nospam@nospam.com (remotehost@hotmail.com)                     |" + STR_NEWLINE + ".--------------------------------------------------------------------." + STR_NEWLINE + "[16:44:33] My user name: Hello there" + STR_NEWLINE + "[16:45:02] Recipient's : hi" + STR_NEWLINE + "[16:45:49] My user name: How are you?" + STR_NEWLINE + "[16:46:37] Recipient's : I'm ok" + STR_NEWLINE + "[16:45:02] ::::::::::: : hi" + STR_NEWLINE + "[16:45:49] M:us:r  n:me: How are you?" + STR_NEWLINE + "[16:46:37] Re:::ie:t's : I'm ok" + STR_NEWLINE + "[16:46:38] Recipient's : yourself?" + "";
        String strInput = null;
        int intNameLength = -1;
        boolean blnEnableTruncate = false;
        if (args == null || args.length == 0) {
            strInput = STR_SAMPLE_CHATLOG;
        } else {
            if (args.length > 3) {
                System.out.println("WARNING: Arguments more than the second are ignored!");
            }
            if (args.length == 3) {
                try {
                    blnEnableTruncate = args[2].equalsIgnoreCase("Y");
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
            if (args.length == 3 || args.length == 2) {
                try {
                    intNameLength = Integer.parseInt(args[1]);
                    if (intNameLength < 1) {
                        throw new IllegalArgumentException("WARNING: Name length must be 1 or greater.");
                    }
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
            try {
                strInput = Main.readTextFile(new File(args[0]));
                if (strInput == null) {
                    System.out.println("WARNING: File is null.");
                    throw new Exception("WARNING: File is null.");
                }
            }
            catch (Exception ex) {
                System.out.println("WARNING: File could not be read.");
                strInput = STR_SAMPLE_CHATLOG;
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
        String strHeader = "";
        String strContent = "";
        String[] strArraySplit = strInput.split("[\\r\\n]+");
        ArrayList<String> alistHeader = new ArrayList<String>();
        ArrayList<String> alistContent = new ArrayList<String>();
        int intNumberOfContacts = 0;
        Contact[] contactsArray = null;
        Pattern patternSessionStartDate = Pattern.compile("(\\d{1,2})[ -]([\\dA-Za-z]+)[ -](\\d{2,4})");
        Pattern patternTimestamp = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}");
        Pattern patternHeaderContactName = Pattern.compile("(\\|\\s+)(.+)(?=.+\\([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)", 194);
        Pattern patternHeaderContactEmail = Pattern.compile("(\\()([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)(\\))", 194);
        Pattern patternCommand = Pattern.compile("(Open|Cancel)(\\([a-z]{3}\\+[a-z]{1}\\))", 2);
        Matcher matcher = null;
        SimpleDateFormat dfDayMonthYear = new SimpleDateFormat("dd MMMMM yyyy");
        SimpleDateFormat dfDayMonthYearTime = new SimpleDateFormat("dd MMMMM yyyy HH:mm:ss");
        SimpleDateFormat dfYearMonthDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dfYearMonthDayTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dfTimestamp = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat dfFilename = new SimpleDateFormat("yyyy-MM-dd.HHmmss");
        Date dateSessionStart = null;
        String strSessionStartDate = null;
        String strSessionStartTime = null;
        int INT_LINES_IN_HEADER = Main.getLastHeaderLine(strArraySplit) + 1;
        int INT_FIRST_CONTACT_LINE = Main.getFirstHeaderContactLine(strArraySplit);
        int INT_TIMESTAMP_LENGTH = Main.getTimestampLength(strArraySplit, INT_LINES_IN_HEADER);
        for (i = 0; i < INT_LINES_IN_HEADER; ++i) {
            alistHeader.add(strArraySplit[i]);
            strHeader = strHeader + strArraySplit[i] + (i != INT_LINES_IN_HEADER - 1 ? STR_NEWLINE : "");
        }
        for (i = INT_LINES_IN_HEADER; i < strArraySplit.length; ++i) {
            alistContent.add(strArraySplit[i]);
            strContent = strContent + strArraySplit[i] + (i != strArraySplit.length - 1 ? STR_NEWLINE : "");
        }
        Main.printArrayList(alistHeader);
        matcher = patternSessionStartDate.matcher((CharSequence)alistHeader.get(1));
        if (matcher.find()) {
            strSessionStartDate = matcher.group(0);
        } else {
            System.out.println("WARNING: \"Session Start\" date not found in header.");
        }
        matcher = patternHeaderContactEmail.matcher(strHeader);
        while (matcher.find()) {
            ++intNumberOfContacts;
        }
        Main.println("Number of Contacts: " + intNumberOfContacts);
        contactsArray = new Contact[intNumberOfContacts];
        for (i = 0; i < contactsArray.length; ++i) {
            contactsArray[i] = new Contact();
            matcher = patternHeaderContactName.matcher((CharSequence)alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find()) {
                contactsArray[i].setName(matcher.group(2));
            } else {
                System.out.println("WARNING: Name not found in header.");
            }
            matcher = patternHeaderContactEmail.matcher((CharSequence)alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find()) {
                contactsArray[i].setEmail(matcher.group(2));
            } else {
                System.out.println("WARNING: Email not found in header.");
            }
            System.out.println("Contact " + (i + 1) + ":");
            System.out.println("\tName: " + contactsArray[i].getName());
            System.out.println("\tEmail: " + contactsArray[i].getEmail());
            System.out.println();
        }
        matcher = patternTimestamp.matcher((CharSequence)alistContent.get(0));
        if (matcher.find()) {
            strSessionStartTime = matcher.group(0);
            try {
                dateSessionStart = dfDayMonthYearTime.parse(strSessionStartDate + " " + strSessionStartTime);
            }
            catch (Exception ex) {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        } else {
            System.out.println("WARNING: First timestamp not found in chatlog.");
        }
        ArrayList<Date> alistContactTimestamp = new ArrayList<Date>();
        ArrayList<String> alistContactName = new ArrayList<String>();
        ArrayList<String> alistContactMessage = new ArrayList<String>();
        String[] strArrayContent = null;
        String strContactTimestamp = null;
        String strAfterTimestamp = null;
        boolean blnAssumeStatusAction = false;
        boolean blnAssumeStatusActionMultiline = false;
        boolean blnAssumeMessageMultiline = false;
        for (int i2 = 0; i2 < alistContent.size(); ++i2) {
            matcher = patternTimestamp.matcher((CharSequence)alistContent.get(i2));
            if (matcher.find()) {
                strContactTimestamp = matcher.group(0);
                try {
                    Date dateTimestamp = dfTimestamp.parse(strContactTimestamp);
                    alistContactTimestamp.add(dateTimestamp);
                    strAfterTimestamp = ((String)alistContent.get(i2)).substring(INT_TIMESTAMP_LENGTH);
                    blnAssumeStatusAction = false;
                    blnAssumeStatusActionMultiline = false;
                    blnAssumeMessageMultiline = false;
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            } else {
                System.out.println("WARNING: Timestamp not found in chatlog line " + (INT_LINES_IN_HEADER + i2 + 1) + ". Assuming last timestamp!");
                strAfterTimestamp = (String)alistContent.get(i2);
                if (blnAssumeStatusAction) {
                    blnAssumeStatusActionMultiline = true;
                } else {
                    blnAssumeMessageMultiline = true;
                }
            }
            if (blnAssumeMessageMultiline) {
                int intLastContactMessageIndex = alistContactMessage.size() - 1;
                alistContactMessage.set(intLastContactMessageIndex, (String)alistContactMessage.get(intLastContactMessageIndex) + "<br/>" + ((String)alistContent.get(i2)).trim());
                blnAssumeMessageMultiline = false;
                continue;
            }
            if (blnAssumeStatusActionMultiline) {
                System.out.println("WARNING: Chatlog line " + (INT_LINES_IN_HEADER + i2 + 1) + " contains no timestamp but recently triggered status and action text detection. Assuming status and action text!");
                int intLastContactMessageIndex = alistContactMessage.size() - 1;
                alistContactMessage.set(intLastContactMessageIndex, (String)alistContactMessage.get(intLastContactMessageIndex) + " " + ((String)alistContent.get(i2)).trim());
                blnAssumeStatusActionMultiline = false;
                continue;
            }
            matcher = patternCommand.matcher(strAfterTimestamp);
            blnAssumeStatusAction = strAfterTimestamp.startsWith("* ") ? true : (strAfterTimestamp.contains("have failed to receive file") || strAfterTimestamp.contains("have successfully received") ? true : !strAfterTimestamp.contains(": ") && matcher.find());
            if (blnAssumeStatusAction) {
                alistContactName.add(STR_STATUS_ACTION_HASH);
                alistContactMessage.add(strAfterTimestamp);
                continue;
            }
            strArrayContent = intNameLength == -1 ? strAfterTimestamp.split(": ", 2) : new String[]{strAfterTimestamp.substring(0, intNameLength), strAfterTimestamp.substring(intNameLength + 2)};
            boolean blnContactFound = false;
            if (!blnEnableTruncate) {
                for (int contact = 0; !blnContactFound && contact < contactsArray.length; ++contact) {
                    if (!contactsArray[contact].getName().startsWith(strArrayContent[0])) continue;
                    alistContactName.add(contactsArray[contact].getName());
                    blnContactFound = true;
                }
            }
            if (!blnContactFound) {
                alistContactName.add(strArrayContent[0]);
            }
            if (strArrayContent.length == 1) {
                alistContactMessage.add("");
                System.out.println("WARNING: Chatlog line " + (INT_LINES_IN_HEADER + i2 + 1) + " contains no message. Assuming multiline message!");
                blnAssumeMessageMultiline = true;
                continue;
            }
            String strContactMessage = strArrayContent[1];
            if (strArrayContent.length >= 2) {
                for (int x = 2; x < strArrayContent.length; ++x) {
                    strContactMessage = strContactMessage + ": " + strArrayContent[x];
                }
            }
            alistContactMessage.add(strContactMessage);
        }
        String strOutput = "";
        strOutput = strOutput + "<html><head><title>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</title></head><body><h3>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</h3>";
        if (alistContactTimestamp.size() == alistContactName.size() && alistContactTimestamp.size() == alistContactMessage.size()) {
            for (int i3 = 0; i3 < alistContactTimestamp.size(); ++i3) {
                strOutput = strOutput + STR_NEWLINE;
                strOutput = contactsArray[0].getName().startsWith((String)alistContactName.get(i3)) ? strOutput + "<font color=\"#16569E\"><font size=\"2\">(" + dfTimestamp.format((Date)alistContactTimestamp.get(i3)) + ")</font> <b>" + (String)alistContactName.get(i3) + ":</b></font> <font sml=\"MSN\">" + (String)alistContactMessage.get(i3) + "</font><br/>" : (((String)alistContactName.get(i3)).equals(STR_STATUS_ACTION_HASH) ? strOutput + "<font color=\"#16569E\"><font size=\"2\">(" + dfTimestamp.format((Date)alistContactTimestamp.get(i3)) + ")</font> <b>" + "STATUS/ACTION" + ":</b></font> <font sml=\"MSN\">" + (String)alistContactMessage.get(i3) + "</font><br/>" : strOutput + "<font color=\"#A82F2F\"><font size=\"2\">(" + dfTimestamp.format((Date)alistContactTimestamp.get(i3)) + ")</font> <b>" + (String)alistContactName.get(i3) + ":</b></font> <font sml=\"MSN\"><span style=\"font-family: High Tower Text;\"><strong><span style=\"color: #ff0000;\">" + (String)alistContactMessage.get(i3) + "</span></strong></span></font><br/>");
            }
            strOutput = strOutput + "</body></html>";
        } else {
            System.out.println("WARNING: Number of contact timestamps, names, and messages do not match.");
            Main.println("alistContactTimestamp.size(): " + alistContactTimestamp.size());
            Main.println("alistContactName.size(): " + alistContactName.size());
            Main.println("alistContactMessage.size(): " + alistContactMessage.size());
        }
        File currentDirectory = null;
        File folderPath = null;
        String strFoldername = contactsArray[1].getEmail();
        String strFilename = dfFilename.format(dateSessionStart) + ".html";
        try {
            currentDirectory = new File(".");
            folderPath = new File(currentDirectory.getCanonicalPath() + File.separator + strFoldername);
            folderPath.mkdirs();
            Main.writeTextFile(folderPath.getPath() + File.separator + strFilename, strOutput);
            System.out.println();
            System.out.println("MESSAGE: File written to " + STR_NEWLINE + folderPath.getPath() + File.separator + strFilename);
            System.out.println();
            System.out.println("MESSAGE: Do not lose or delete your legacy chatlogs. It is harder to convert backwards or recover from something that went wrong!");
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
    }

    private static void setOutEncoding() {
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
    }

    private static String retrieveInput(String strInputText) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(strInputText);
        return scanner.nextLine();
    }

    private static int getLastHeaderLine(String[] strArrayChatlog) {
        for (int i = 1; i < strArrayChatlog.length; ++i) {
            if (!strArrayChatlog[i].startsWith(".---------------------------------")) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstHeaderContactLine(String[] strArrayChatlog) {
        for (int i = 1; i < strArrayChatlog.length; ++i) {
            if (!strArrayChatlog[i].startsWith("| Participants:")) continue;
            return i + 1;
        }
        return -1;
    }

    private static int getTimestampLength(String[] strArrayChatlog, int intFirstContentLine) {
        Pattern patternTimestamp = Pattern.compile("(\\W)([0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2})(\\W\\s)");
        Matcher matcher = patternTimestamp.matcher(strArrayChatlog[intFirstContentLine]);
        if (matcher.find()) {
            return matcher.end();
        }
        System.out.println("WARNING: First timestamp not found in content.");
        return -1;
    }

    private static boolean isInteger(String strInput) {
        try {
            Integer.parseInt(strInput);
            return true;
        }
        catch (NumberFormatException exNumberFormat) {
            return false;
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private static boolean isDouble(String strInput) {
        try {
            Double.parseDouble(strInput);
            return true;
        }
        catch (NumberFormatException exNumberFormat) {
            return false;
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private static void print(Object objPrint) {
        System.out.print(objPrint.toString());
    }

    private static void println(Object objPrint) {
        System.out.println(objPrint.toString());
    }

    private static void printArray(Object[] objArray) {
        for (Object obj : objArray) {
            System.out.println(obj.toString());
        }
    }

    private static void printArrayList(ArrayList alistArray) {
        for (Object obj : alistArray) {
            System.out.println(obj.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTextFile(File file) throws Exception {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            stringBuilder = new StringBuilder(1024);
            char[] charBuffer = new char[1024];
            int intRead = 0;
            while ((intRead = bufferedReader.read(charBuffer)) > -1) {
                stringBuilder.append(charBuffer, 0, intRead);
                charBuffer = new char[1024];
            }
        }
        catch (IOException exIO) {
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextFile(String strFilename, String strFileContent) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(strFilename), "UTF-8");
            writer.write(strFileContent);
        }
        catch (IOException exIO) {
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (Exception ex) {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

