/*!
 * plusQuery JavaScript Library 0.0.2
 * http://github.com/tyscorp/plusquery/
 *
 * Copyright (C) 2011 by Tyson Cleary
 * 
 * Licensed under the MIT license.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * Contains code and concepts from the jQuery JavaScript Library.
 * http://jquery.com/
 * Copyright 2011, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Date: Wed Apr 6 14:33:33 2011 +1000
 */
 
(function () {
var type = (function () {

	var types = [
		"Boolean",
		"Number",
		"String",
		"Function",
		"Array",
		"Date",
		"RegExp",
		"Object"
	];
	
	var class2type = {};
	
	for (var i = 0; i < types.length; i++) {
		class2type["[object " + types[i] + "]"] = types[i].toLowerCase();
	}
	
	var toString = Object.prototype.toString;

	return function (object) {
		if (object === null) { return "null"; }
		if (typeof object === "undefined") { return "undefined"; }
		return class2type[toString.call(object)];
	};
})();

Object.extend = Object.prototype.extend = function () {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if (typeof target === "boolean") {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if (typeof target !== "object" && !Object.isFunction(target)) {
		target = {};
	}

	// Extend the object itself if only one argument is passed
	if (length === i) {
		target = this;
		--i;
	}

	for (; i < length; i++) {
		// Only deal with non-null/undefined values
		if ((options = arguments[ i ]) !== null) {
			// Extend the base object
			for (name in options) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if (target === copy) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if (deep && copy && (Object.isPlainObject(copy) || (copyIsArray = Object.isArray(copy)))) {
					if (copyIsArray) {
						copyIsArray = false;
						clone = src && Object.isArray(src) ? src : [];

					} else {
						clone = src && Object.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = Object.extend(deep, clone, copy);

				// Don't bring in undefined values
				} else if (copy !== undefined) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

Object.extend({
	isFunction: function (object) {
		return type(object) === "function";
	},
	isArray: function (object) {
		return type(object) === "array";
	},
	isString: function (object) {
		return type(object) === "string";
	},
	isNumber: function (object) {
		return type(object) === "number";
	},
	isDate: function (object) {
		return type(object) === "date";
	},
	isUndefined: function (object) {
		return type(object) === "undefined";
	},
	isNaN: function (object) {
		return object == null || !/\d/.test(object) || isNaN(object);
	},
	isPlainObject: function (object) {
		// Must be an Object.
		if (!object || type(object) !== "object") {
			return false;
		}

		// Not own constructor property must be Object
		if (object.constructor &&
			!Object.prototype.hasOwnProperty.call(object, "constructor") &&
			!Object.prototype.hasOwnProperty.call(object.constructor.prototype, "isPrototypeOf")) {
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.

		var property;
		for (property in object) {}

		return key === undefined || Object.prototype.hasOwnProperty.call(object, property);
	},
	isEmptyObject: function (object) {
		for (var property in object) {
			if (object.hasOwnProperty(property)) {
				return false;
			}
		}
		return true;
	},
	error: function (msg) {
		throw msg;
	},
	keys: function (object) {
		if (type(object) !== "object") { throw new TypeError(); }
		var results = [];
		for (var property in object) {
			if (object.hasOwnProperty(property)) {
				results.push(property);
			}
		}
		return results;
	},
	values: function (object) {
		var results = [];
		for (var property in object) {
			if (object.hasOwnProperty(property)) {
				results.push(object[property]);
			}
		}
		return results;
	},
	clone: function (object) {
		return Object.extend({}, object);
	}
});

Object.prototype.extend({
	isFunction: function () {
		return Object.isFunction(this);
	},
	isArray: function () {
		return Object.isArray(this);
	},
	isString: function () {
		return Object.isString(this);
	},
	isNumber: function () {
		return Object.isNumber(this);
	},
	isDate: function () {
		return Object.isDate(this);
	},
	isUndefined: function () {
		return Object.isUndefined(this);
	},
	isNaN: function() {
		return Object.isNaN(this);
	},
	keys: function () {
		return Object.keys(this);
	},
	values: function () {
		return Object.values(this);
	},
	clone: function () {
		return Object.clone(this);
	},
	forEach: function (fn) {
		if (this === undefined || this === null || typeof fn !== "function") { throw new TypeError(); }
		var object = Object(this);
		var len = object.length >>> 0;
		var thisp = arguments[1];
		
		for (var property in object)
		{
			if (object.hasOwnProperty(property)) { fn.call(thisp, object[property], property, object); }
		}
	}
});

Array.prototype.extend({
	forEach: function (fn) {
		if (this === undefined || this === null || typeof fn !== "function") { throw new TypeError(); }
		var object = Object(this);
		var len = object.length >>> 0;
		var thisp = arguments[1];

		for (var i = 0; i < len; i++)
		{
			if (i in object) { fn.call(thisp, object[i], i, object); }
		}
	},
	clone: function () {
		return [].slice.call(this, 0);
	},
	indexOf: function (item, i) {
		if (!i) { i = 0; }
		var length = this.length;
		if (i < 0) {
			i = length + i;
		}
		for (; i < length; i++) {
			if (this[i] === item) {
				return i;
			}
		}
		return -1;
	}
});

String.prototype.trim = function () {
	return this.replace(/^\s*((?:[\S\s]*\S)?)\s*$/, '$1');
};

// Bind function written by Juriy "kangax" Zaytsev, refactored slightly
Function.prototype.bind = (function (slice) {
	return function (context) {
		var fn = this,
			args = slice.call(arguments, 1);

		if (args.length) {
			return function () {
				return arguments.length ?
					fn.apply(context, args.concat(slice.call(arguments))) :
					fn.apply(context, args);
			};
		}
		return function () {
			return arguments.length ?
			fn.apply(context, arguments) :
			fn.call(context);
		};
	};
})(Array.prototype.slice);
/*
 *
 */
plusQuery = (function () {

// Define a local copy of plusQuery
var plusQuery = function (object) {
	return new plusQuery.fn.init(object);
};

// Static functions
plusQuery.extend({
	noop: function () {},

	// A GUID counter for objects
	guid: 1,

	// Current time in MS
	now: function () {
		return (new Date()).getTime();
	},
	
	MyContact: function () {
		return $({
			Email: Messenger.MyEmail,
			Network: 1,
			Status: Messenger.MyStatus,
			Name: Messenger.MyName,
			PersonalMessage: Messenger.MyPersonalMessage,
			CurrentMedia: Messenger.MyCurrentMedia,
			Blocked: false,
			DisplayPicture: Messenger.MyDisplayPicture,
			IsFloating: false,
			ProfileColor: 0
		});
	},
	
	$A: function (iterable) {
		if (!iterable) {
			return [];
		}

		if(iterable.toArray) {
			return iterable.toArray();
		}

		var length = iterable.length || 0;
		var results = new Array(length);

		while (length--) {
			results[length] = iterable[length];
		}

		return results;
	},
	
	version: "0.0.2"
});

plusQuery.fn = plusQuery.prototype = {
	constructor: plusQuery,
	// This acts as the constructor.
	init: function (object) {
	
		// HANDLE: $(falsey) and $(plusQuery)
		if (!object || object instanceof plusQuery) {
			return this;
		}

		/*  We can test for all of the Messenger Plus! objects with
		 *  reasonable certainty because the typeof the functions are
		 *  "unknown", not "function".
		 *  For those without functions, (Contact and Emoticon) we do a bit
		 *  more testing just in case.
		 */
		
		// HANDLE: $(Debug)
		if (typeof object.Trace === "unknown") {
			return this.extend(new plusQuery.wrappers.Debug(object));
		}
		
		// HANDLE: $(Messenger)
		if (typeof object.AutoSignin === "unknown") {
			return this.extend(new plusQuery.wrappers.Messenger(object));
		}
		
		// HANDLE: $(MsgPlus)
		if (typeof object.LockMessenger === "unknown") {
			return this.extend(new plusQuery.wrappers.MsgPlus(object));
		}
		
		// HANDLE: $(Contacts)
		if (typeof object.GetContact === "unknown") {
			return this.extend(new plusQuery.wrappers.Contacts(object));
		}
		
		// HANDLE: $(Emoticons)
		if (typeof object.GetEmoticons === "unknown") {
			return this.extend(new plusQuery.wrappers.Emoticons(object));
		}
		
		// Handle $(ChatWnds)
		if (object.Count) {
			return this.extend(new plusQuery.wrappers.ChatWnds(object));
		}
		
		// Handle $(ChatWnd)
		if (typeof object.SendMessage === "unknown") {
			return this.extend(new plusQuery.wrappers.ChatWnd(object));
		}
		
		// HANDLE: $(Contact)
		if (typeof object.Email !== "undefined" &&
			typeof object.Network !== "undefined" &&
			typeof object.Status !== "undefined" &&
			typeof object.Name !== "undefined" &&
			typeof object.PersonalMessage !== "undefined" &&
			typeof object.CurrentMedia !== "undefined" &&
			typeof object.DisplayPicture !== "undefined") {
			
			return this.extend(new plusQuery.wrappers.Contact(object));
		}
		
		// HANDLE: $(Emoticon)
		if (typeof object.Shortcut !== "undefined" &&
			typeof object.Name !== "undefined" &&
			typeof object.PictureFile !== "undefined") {
			
			return this.extend(new plusQuery.wrappers.Emoticon(object));
		}
		
		// HANDLE: $(PlusWnd)
		if (typeof object.Close === "unknown") {
			return this.extend(new plusQuery.wrappers.PlusWnd(object));
		}
		
		// HANDLE: $(Interop)
		if (typeof object.Call === "unknown") {
			return this.extend(new plusQuery.wrappers.Interop(object));
		}
		
		// HANDLE: $(DataBloc)
		if (typeof object.SetAt === "unknown") {
			return this.extend(new plusQuery.wrappers.DataBloc(object));
		}
		
		return this;
	},
	
	// The default length of a plusQuery object is 0
	length: 0,
	
	// The number of elements contained in the matched element set
	size: function () {
		return this.length;
	},

	// Converts the object to an array
	toArray: function () {
		return Array.prototype.slice.call(this, 0);
	},
	
	type: "PlusQuery",
	
	toString: function () {
		return "[object " + this.type + "]";
	}
};

// Give the init function the plusQuery prototype for later instantiation
plusQuery.fn.init.prototype = plusQuery.fn;

$ = plusQuery;

return plusQuery;
})();
/*  
 *  [[plusQuery.wrappers.*]]
 *
 *  This section defines a group of wrapper objects. Basically, these are
 *  all just objects with pointers to the properties of the original
 *  interfaces included in the Messenger Plus! API.
 *  This is an implementation to get around the fact that these "objects"
 *  have no prototype property, and so can't really be changed.
 *
 *  The property "this.original" is there to access the original interface.
 *  (proxy pattern) You /can/ create objects directly from $.wrappers,
 *  however you should use the plusQuery constructor so you inherit all of 
 *  plusQuery's functions, etc.
 *
 *  This "solves" the problem here: http://msghelp.net/showthread.php?tid=62818
 *
 *  The call to init (this.init.call(this, this.original)) on the interface objects
 *  is there so you can overload the "constructor" of the wrapper.
 *  
 *
 *
 *  Example usage: overload ChatWnd.SendMessage for a single $(ChatWnd) object
 *  to implement a message prefix
 *
 *  var chatWnd = $(chatWnd);
 *  chatWnd.SendMessage = function(Text) {
 *      this.original.SendMessage("[Ye] " + Text);
 *  }
 *
 *
 *  Example usage: overload ChatWnd.SendMessage for all $(ChatWnd) objects to
 *  implement a message prefix.
 *
 *  $.wrappers.ChatWnd.prototype.SendMessage = function(Text) {
 *      this.original.SendMessage("[Ye] " + Text);
 *  }
 *
 *  Example usage: overload the "constructor" of $(ChatWnd) to print something
 *
 *  $.wrappers.ChatWnd.prototype.init = function() {
 *      Debug.Trace("$(ChatWnd) object created");
 *  }
 *
 */
(function ($) {
 
plusQuery.wrappers = {
	Debug: function (object) {
		this.original = object;
		this.type = "Debug";
		
		this.DebuggingWindowVisible = this.original.DebuggingWindowVisible;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Messenger: function (object) {
		this.original = object;
		this.type = "Messenger";
		
		this.Version = this.original.Version;
		this.VersionBuild = this.original.VersionBuild;
		this.ContactListWndHandle = this.original.ContactListWndHandle;
		this.CurrentChats = this.original.CurrentChats;
		this.ReceiveFileDir = this.original.ReceiveFileDir;
		this.MyContacts = this.original.MyContacts;
		this.MyEmail = this.original.MyEmail;
		this.MyUserId = this.original.MyUserId;
		this.MyStatus = this.original.MyStatus;
		this.MyName = this.original.MyName;
		this.MyPersonalMessage = this.original.MyPersonalMessage;
		this.MyCurrentMedia = this.original.MyCurrentMedia;
		this.MyDisplayPicture = this.original.MyDisplayPicture;
		this.CustomEmoticons = this.original.CustomEmoticons;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	MsgPlus: function (object) {
		this.original = object;
		this.type = "MsgPlus";
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	ChatWnds: function (object) {
		this.original = object;
		this.type = "ChatWnds";
		
		this.Count = this.original.Count;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	ChatWnd: function (object) {
		this.original = object;
		this.type = "ChatWnd";
	
		this.Handle = this.original.Handle;
		this.Contacts = this.original.Contacts;
		this.EditText = this.original.EditText;
		this.EditChangeAllowed = this.original.EditChangeAllowed;
		this.ChatLogEnabled = this.original.ChatLogEnabled;
		this.OverrideFmtEnabled = this.original.OverrideFmtEnabled;
		this.IsMobileChat = this.original.IsMobileChat;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Contacts: function (object) {
		this.original = object;
		this.type = "Contacts";
		
		this.Count = this.original.Count;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Contact: function (object) {
		this.original = object;
		this.type = "Contact";
		
		this.Email = this.original.Email;
		this.Network = this.original.Network;
		this.Status = this.original.Status;
		this.Name = this.original.Name;
		this.PersonalMessage = this.original.PersonalMessage;
		this.CurrentMedia = this.original.CurrentMedia;
		this.Blocked = this.original.Blocked;
		this.DisplayPicture = this.original.DisplayPicture;
		this.IsFloating = this.original.IsFloating;
		this.ProfileColor = this.original.ProfileColor;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Emoticons: function (object) {
		this.original = object;
		this.type = "Emoticons";
		
		this.Count = this.original.Count;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Emoticon: function (object) {
		this.original = object;
		this.type = "Emoticon";
		
		this.Shortcut = this.original.Shortcut;
		this.Name = this.original.Name;
		this.PictureFile = this.original.PictureFile;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	PlusWnd: function (object) {
		this.original = object;
		this.type = "PlusWnd";
		
		this.Handle = this.original.Handle;
		this.Visible = this.original.Visible;
		this.WindowId = this.original.WindowId;
		this.BaseColor = this.original.BaseColor;
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	Interop: function (object) {
		this.original = object;
		this.type = "Interop";
		
		this.init.call(this, this.original);
		
		return this;
	},
	
	DataBloc: function (object) {
		this.original = object;
		this.type = "DataBloc";
		
		this.Size = this.original.Size;
		this.DataPtr = this.original.DataPtr;
		
		this.init.call(this, this.original);
		
		return this;
	}
};

/*  
 *  The following define the default methods of the interfaces, plus the "init"
 *  "constructor".
 */
$.wrappers.Debug.prototype = {
	init: function (object) {},
	
	Trace: function (Text) {
		return this.original.Trace(Text);
	},
	
	ClearDebuggingWindow: function () {
		return this.original.ClearDebuggingWindow();
	}	
};

$.wrappers.Messenger.prototype = {
	init: function (object) {},
	
	AutoSignin: function () {
		return this.original.AutoSignin();
	},
	
	Signout: function () {
		return this.original.Signout();
	},
	
	OpenChat: function (Contact) {
		return this.original.OpenChat(Contact);
	}
};

$.wrappers.MsgPlus.prototype = {
	init: function (object) {},
	
	DisplayToast: function (Title, Message, SoundFile, Callback, CallbackParam) {
		return this.original.DisplayToast(Title, Message, SoundFile, Callback, CallbackParam);
	},
	
	DisplayToastContact: function (Title, ContactName, Message, SoundFile, Callback, CallbackParam, Contact) {
		return this.original.DisplayToastContact(Title, ContactName, Message, SoundFile, Callback, CallbackParam, Contact);
	},
	
	CreateWnd: function (XmlFile, WindowId, Options) {
		return this.original.CreateWnd(XmlFile, WindowId, Options);
	},
	
	CreateChildWnd: function (Parent, XmlFile, WindowId, PosX, PosY, Visible) {
		return this.original.CreateChildWnd(Parent, XmlFile, WindowId, PosX, PosY, Visible);
	},
	
	AddTimer: function (TimerId, Elapse) {
		return this.original.AddTimer(TimerId, Elapse);
	},
	
	CancelTimer: function (TimerId) {
		return this.original.CancelTimer(TimerId);
	},
	
	PlaySound: function (SoundFile, MaxPlayTime) {
		return this.original.PlaySound(SoundFile, MaxPlayTime);
	},
	
	LockMessenger: function (Lock) {
		return this.original.LockMessenger(Lock);
	},
	
	LogEvent: function (Origin, Description, Icon) {
		return this.original.LogEvent(Origin, Description, Icon);
	},
	
	RemoveFormatCodes: function (Text) {
		return this.original.RemoveFormatCodes(Text);
	},
	
	DownloadFile: function (Url, OutFile, User, Password) {
		return this.original.DownloadFile(Url, OutFile, User, Password);
	},
	
	UploadFileFTP: function (SourceFile, Server, User, Password, Destination, PassiveMode, Port) {	
		return this.original.UploadFileFTP(SourceFile, Server, User, Password, Destination, PassiveMode, Port);
	},
	
	LoadScriptFile: function (ScriptFile) {
		return this.original.LoadScriptFile(ScriptFile);
	},
	
	ExtractFromZIP: function (ZipFile, DestDirectory, FileNames, Password) {
		return this.original.ExtractFromZIP(ZipFile, DestDirectory, FileNames, Password);
	}
};

$.wrappers.ChatWnds.prototype = {
	init: function (object) {},
	
	Iterator: function () {
		return this.original.Iterator();
	}
};

$.wrappers.ChatWnd.prototype = {
	init: function (object) {},
	
	SendMessage: function (Message) {
		return this.original.SendMessage(Message);
	},
	
	SendFile: function (FilePath) {
		return this.original.SendFile(FilePath);
	},
	
	AddContact: function (Email) {
		return this.original.AddContact(Email);
	},
	
	DisplayInfoMessage: function (Message, Duration, ForceNow) {
		return this.original.DisplayInfoMessage(Message, Duration, ForceNow);
	},
	
	ResetInfoMessage: function () {
		return this.original.ResetInfoMessage();
	},
	
	EditText_SetCurSelStart: function () {
		return this.original.EditText_SetCurSelStart();
	},
	
	EditText_SetCurSelEnd: function () {
		return this.original.EditText_SetCurSelEnd();
	},
	
	EditText_SetCurSel: function (Start, End) {
		return this.original.EditText_SetCurSel(Start, End);
	},
	
	EditText_ReplaceSel: function (Text) {
		return this.original.EditText_ReplaceSel(Text);
	},
	
	HistoryText_GetCurSelStart: function () {
		return this.original.HistoryText_GetCurSelStart();
	},
	
	HistoryText_GetCurSelEnd: function () {
		return this.original.HistoryText_GetCurSelEnd();
	},
	
	HistoryText_GetTextRange: function (StartIdx, EndIdx, AddObjectCodes) {
		return this.original.HistoryText_GetTextRange(StartIdx, EndIdx, AddObjectCodes);
	}
};

$.wrappers.Contacts.prototype = {
	init: function (object) {},
	
	Iterator: function () {
		return this.original.Iterator();
	},
	
	GetContact: function (Email) {
		return this.original.GetContact(Email);
	}
};

$.wrappers.Contact.prototype = {
	init: function (object) {
		
	}
};

$.wrappers.Emoticons.prototype = {
	init: function (object) {},
	
	Iterator: function () {
		return this.original.Iterator();
	},
	
	GetEmoticon: function (Shortcut) {
		return original.GetEmoticon(Shortcut);
	}
};

$.wrappers.Emoticon.prototype = {
	init: function (object) {
		
	}
};

$.wrappers.PlusWnd.prototype = {
	init: function (object) {
		
	}
};

$.wrappers.Interop.prototype = {
	init: function (object) {},
	
	Call: function (DllName, FunctionName, Param1, Param2,
		Param3, Param4, Param5, Param6, Param7, Param8, Param9,
		Param10, Param11, Param12) {
		
		return this.original.Call(DllName, FunctionName, Param1, Param2,
			Param3, Param4, Param5, Param6, Param7, Param8, Param9,
			Param10, Param11, Param12);
	},
	
	Call2: function (DllName, FunctionName, Param1, Param2,
		Param3, Param4, Param5, Param6, Param7, Param8, Param9,
		Param10, Param11, Param12) {
		
		return this.original.Call2(DllName, FunctionName, Param1, Param2,
			Param3, Param4, Param5, Param6, Param7, Param8, Param9,
			Param10, Param11, Param12);
	},
	
	FreeDll: function (DllName) {
		return this.original.FreeDll(DllName);
	},
	
	GetLastError: function () {
		return this.original.GetLastError();
	},
	
	Allocate: function (InitialSize) {
		return this.original.Allocate(InitialSize);
	},
	
	GetCallbackPtr: function (FunctionName) {
		return this.original.GetCallbackPtr(FunctionName);
	}
};

$.wrappers.DataBloc.prototype = {
	init: function (object) {},
	
	GetAt: function (Offset) {
		return this.original.GetAt(Offset);
	},
	
	SetAt: function (Offset, Byte) {
		return this.original.SetAt(Offset, Byte);
	},
	
	ReadString: function () {
		return this.original.ReadString();
	},
	
	WriteString: function (Offset, String, WriteUnicode) {
		return this.original.WriteString(Offset, String, WriteUnicode);
	},
	
	ReadBSTR: function () {
		return this.original.ReadBSTR();
	},
	
	WriteBSTR: function () {
		return this.original.WriteBSTR();
	},
	
	ReadWORD: function () {
		return this.original.ReadWORD();
	},
	
	WriteWORD: function () {
		return this.original.WriteWORD();
	},
	
	ReadDWORD: function () {
		return this.original.ReadDWORD();
	},
	
	WriteDWORD: function () {
		return this.original.WriteDWORD();
	},
	
	ReadInterfacePtr: function () {
		return this.original.ReadInterfacePtr();
	},
	
	WriteInterfacePtr: function () {
		return this.original.WriteInterfacePtr();
	}
};

/*
 *  These are "enhanced" interface objects. They add misc features to make
 *  scripting in Messenger Plus! more... Friendly.
 *
 */
 
/*
 *  [[plusQuery.interfaces.Debug]]
 *  Adds a switch to turn off debug messages to use in shipped code.
 *  
 *  [[plusQuery.interfaces.Debug.Enabled]]
 *  boolean to determine whether to trace or not.
 *
 *  [[plusQuery.interfaces.Debug.Trace]]
 */
$.wrappers.Debug.prototype.extend({
	Enabled: true,
	
	Trace: function (Text) {
		if (this.Enabled) {
			this.original.Trace(String(Text));
		}
	}
});
/*
 *  [[plusQuery.interfaces.Messenger]]
 *  Adds 
 *  
 */
$.wrappers.Messenger = function (object) {
	this.original = object;
	this.type = "Messenger";
	
	this.Version = this.original.Version;
	this.VersionBuild = this.original.VersionBuild;
	this.ContactListWndHandle = this.original.ContactListWndHandle;	
	this.ReceiveFileDir = this.original.ReceiveFileDir;
	this.MyEmail = this.original.MyEmail;
	this.MyUserId = this.original.MyUserId;
	this.MyStatus = this.original.MyStatus;
	this.MyName = this.original.MyName;
	this.MyPersonalMessage = this.original.MyPersonalMessage;
	this.MyCurrentMedia = this.original.MyCurrentMedia;
	this.MyDisplayPicture = this.original.MyDisplayPicture;
	
	// Extend these three to become plusQuery objects
	this.CurrentChats = $(this.original.CurrentChats);
	this.MyContacts = $(this.original.MyContacts);
	this.CustomEmoticons = $(this.original.CustomEmoticons);
	
	return this;
};

// MsgPlus
$.wrappers.MsgPlus.prototype.extend({
	// The default DisplayToast function only allows a string as a callback.
	// Apparently the callback function has to be in global scope, too. :(
	// Silly Patchou. I cannot fathom why he would code it like this...
	DisplayToast: function (Title, Message, SoundFile, Callback,
		CallbackParam) {
		if (Callback.isFunction()) {
			return this.original.DisplayToast(Title, Message, (SoundFile || ""),
				"DisplayToastCallback", [Callback, CallbackParam]);
		}
		
		return this.original.DisplayToast(Title, Message, SoundFile, Callback,
			CallbackParam);
	},
	
	// Pretty much the same as above, but with the contact toast.
	DisplayToastContact: function (Title, ContactName, Message,
		SoundFile, Callback, CallbackParam, Contact) {
		
		if (Callback.isFunction()) {
			return this.original.DisplayToastContact(Title, ContactName, Message,
				(SoundFile || ""), "DisplayToastCallback", [Callback, CallbackParam], Contact);
		}
		
		return this.original.DisplayToastContact(Title, ContactName, Message,
			SoundFile, Callback, CallbackParam, Contact);
	}
});

// ChatWnds
$.wrappers.ChatWnds = function (object) {
	this.original = object;
	this.type = "ChatWnds";
	
	for (var e = new Enumerator(this.original), i = 0; !e.atEnd(); e.moveNext(), i++) {
		this[i] = $(e.item());
	}
	this.length = i;
};

// ChatWnd
$.wrappers.ChatWnd.prototype.extend({
	trigger: function (event, args) {
		if (event.object && event.object.Handle && event.object.Handle === this.Handle) {
			return event.callback.apply(this, args);
		}
	}
});

// Contacts
$.wrappers.Contacts = function(object) {
	this.original = object;
	this.type = "Contacts";
	
	this[0] = $.MyContact();
	for (var e = new Enumerator(this.original), i = 1; !e.atEnd(); e.moveNext(), i++) {
		this[i] = $(e.item());
	}
	this.length = i+1;
};

$.wrappers.Contacts.prototype.extend({
	GetContact: function (str) {
		if (str.toLowerCase() === Messenger.MyEmail.toLowerCase()) {
			return this[0];
		} else if (this.original.GetContact(str)) {
			return $(this.original.GetContact(str));
		} else {
			for (var i = 0; i < this.length; i++) {
				if (this[i].Name === str) {
					return this[i]; // Only returns the first match
				}
			}
		}
		
		return null;
	}
});

// Ugh, polluting my global object!
DisplayToastCallback = function () {
	arguments[0][0].call(this, arguments[0][1]);
};

})(plusQuery);
(function ($) {
	
	var Event = function (object, eventName, callback) {
		this.object = object;
		this.eventName = eventName;
		this.callback = callback;
		this.guid = $.guid++;
	};
	
	Event.CACHE = {};
	
	Event.RETURNS = {
		ChatWndReceiveMessage: 2,
		ChatWndSendMessage: 1,
		OnGetScriptMenu: 0,
		OnGetScriptCommands: 0
	};

	Event.prototype.extend({
	
		start: function () {
			$.addEventListener(this.object, this.eventName, this.callback);
			return this;
		},
		
		stop: function () {
			$.removeEventListener(this.object, this.eventName, this.callback);
			return this;
		},
		
		trigger: function(args) {
			return this.callback.apply(this, args);
		}
	});
	
	$.extend({
	
		Event: Event,
	
		addEventListener: function () {
			var object, eventName, callback;

			// Simulating parametric polymorphism
			if (arguments[0].isString()) {
				object = $;
				eventName = arguments[0];
				callback = arguments[1];
			} else {
				object = arguments[0];
				eventName = arguments[1];
				callback = arguments[2];
			}
			
			eventName = eventName.split(" ");

			for(var i = 0; i < eventName.length; i++) {
				var event = new Event(object, eventName[i], callback);
				Event.CACHE[event.guid] = event;
			}

			return this;
		},
		
		removeEventListener: function (object, eventName, callback) {
			Event.CACHE.forEach(function (event) {
				if(event.object === object && event.eventName === eventName &&
					event.callback === callback) {
						delete Event.CACHE[event.guid];
				}
			});
			
			return this;
		},
		
		bind: function (object, eventName, callback) {
			return new Event(object, eventName, callback).start();
		},
		
		trigger: function (object, eventName, args) {
			var ret;
			Event.CACHE.forEach(function (event) {
				if(event.eventName === eventName) {
					try {
						if (event.object === $) {
							ret = event.trigger(args);
							if (ret != null) {
								args[Event.RETURNS[eventName]] = ret;
							}
						} else {
							ret = object.trigger(event, args);
							if (ret != null) {
								args[Event.RETURNS[eventName]] = ret;
							}
						}
					} catch (err) {
						$(Debug).Trace(err.name + ": " + err.message + " (" + err.number + ")\n\tEvent: " + eventName);
					}
				}
			});
			
			if (args != null && args[Event.RETURNS[eventName]] != null) {
				return args[Event.RETURNS[eventName]];
			}
		}
	});
	
	$.prototype.extend({
		addEventListener: function (eventName, callback) {
			return $.addEventListener(this, eventName, callback);
		},
		
		removeEventListener: function (eventName, callback) {
			return $.removeEventListener(this, eventName, callback);
		},
		
		bind: function (eventName, callback) {
			return $.bind(this, eventName, callback);
		},
		
		trigger: $.noop
	});
	
})(plusQuery);

OnEvent_Signin = function () {
	var args = plusQuery.plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "Signin", args);
};

OnEvent_SigninReady = function () {
	var args = plusQuery.plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "SigninReady", args);
};

OnEvent_Signout = function () {
	var args = plusQuery.plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "Signout", args);
};

OnEvent_MyStatusChange = function () {
	var args = plusQuery.plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery.MyContact(), "MyStatusChange", args);
};

OnEvent_MyNameChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery.MyContact(), "MyNameChange", args);
};

OnEvent_MyPsmChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery.MyContact(), "MyPsmChange", args);
};

OnEvent_MyMediaChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery.MyContact(), "MyMediaChange", args);
};

OnEvent_ContactSignin = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactSignin", args);
};

OnEvent_ContactSignout = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactSignout", args);
};

OnEvent_ContactStatusChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactStatusChange");
};

OnEvent_ContactNameChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactNameChange");
};

OnEvent_ContactPsmChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactPsmChange", args);
};

OnEvent_ContactMediaChange = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactMediaChange");
};

OnEvent_ContactBlocked = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactBlocked", args);
};

OnEvent_ContactUnblocked = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(Messenger.MyContacts.GetContact(args[0])), "ContactUnblocked", args);
};

OnEvent_ContactListWndCreated = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "ContactListWndCreated", args);
};

OnEvent_ContactListWndDestroyed = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "ContactListWndDestroyed", args);
};

OnEvent_ChatWndCreated = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndCreated", args);
};

OnEvent_ChatWndDestroyed = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndDestroyed", args);
};

OnEvent_ChatWndContactAdded = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndContactAdded", args);
};

OnEvent_ChatWndContactRemoved = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndContactRemoved", args);
};

OnEvent_ChatWndReceiveMessage = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndReceiveMessage", args);
};

OnEvent_ChatWndSendMessage = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndSendMessage", args);
};

/*OnEvent_ChatWndEditKeyDown = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[0]), "ChatWndEditKeyDown", args);
};*/

OnEvent_Initialize = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "Initialize", args);
};

OnEvent_Uninitialize = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "Uninitialize", args);
};

OnEvent_MessengerLocked = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "MessengerLocked", args);
};

OnEvent_MessengerUnlocked = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "MessengerUnlocked", args);
};

OnEvent_Timer = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "Timer", args);
};

OnEvent_MenuClicked = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery(args[2]), "MenuClicked", args);
};

OnEvent_EnterPersonalizedStatus = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "EnterPersonalizedStatus", args);
};

OnEvent_LeavePersonalizedStatus = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "LeavePersonalizedStatus", args);
};

OnEvent_DownloadFileComplete = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "DownloadFileComplete", args);
};

OnEvent_UploadFileComplete = function () {
	var args = plusQuery.$A(arguments);
	return plusQuery.trigger(plusQuery, "UploadFileComplete", args);
};

OnGetScriptMenu = function () {
	var args = plusQuery.$A(arguments);
	args.push({});
	return plusQuery.trigger(plusQuery, "OnGetScriptMenu", args);
};

OnGetScriptCommands = function () {
	var args = plusQuery.$A(arguments);
	args.push([]);
	var cmds = plusQuery.trigger(plusQuery, "OnGetScriptCommands", args);
	var cmdStr = "<ScriptCommands>";
	for (var i = 0; i < cmds.length; i++) {
		cmdStr += "<Command>";
		cmdStr += "<Name>" + (cmds[i].Name || "") + "</Name>";
		cmdStr += "<Description>" + (cmds[i].Description || "") + "</Description>";
		cmdStr += "<Parameters>" + (cmds[i].Parameters || "") + "</Parameters>";
		cmdStr += "</Command>";
	}
	return cmdStr + "</ScriptCommands>";
};
(function ($) {

	var Timer = function (callback, delay, repeat) {
		this.callback = callback;
		this.delay = delay;
		this.repeat = repeat;
		this.id = "plusQuery#" + $.guid++;
		Timer.CACHE[this.id] = this;
	};
	
	Timer.CACHE = {};
	
	Timer.prototype.extend({
		start: function () {
			if (this.delay < 300) {
				this.trigger();
			} else if(this.delay > 86400000) {
				return (new Timer(this.callback, this.delay - 86400000, this.repeat)).start();
			} else {
				MsgPlus.AddTimer(this.id, this.delay);
			}
			return this;
		},
		
		cancel: function () {
			MsgPlus.CancelTimer(this.id);
			delete Timer.CACHE[this.id];
			return this;
		},
		
		trigger: function () {
			this.callback.apply(this);
			if(this.repeat) {
				this.start();
			}
		}
	});
	
	$.extend({
		setTimeout: function (callback, delay) {
			return (new Timer(callback, delay, false)).start();
		},
		
		setInterval: function (callback, delay) {
			return (new Timer(callback, delay, true)).start();
		},
		
		clearTimeout: function (timer) {
			if (timer.id) {
				Timer.CACHE[timer.id].cancel();
			} else {
				Timer.CACHE[timer].cancel();
			}
			
		},
		
		clearInterval: this.clearTimeout
	});
	
	$.addEventListener('Timer', function(timerId) {
		if(timerId.match(/plusQuery#(\d+)/) && Timer.CACHE[timerId] && Timer.CACHE[timerId].callback)
		{
			Timer.CACHE[timerId].trigger();
		}
	});

})(plusQuery);(function ($) {
	
	var Command = function (commandName, external, callback) {
		this.commandName = commandName.toUpperCase();
		this.external = (external != null ? external : (commandName.substr(0, 1) === "/" ? false : true) );
		this.callback = callback;
		this.guid = $.guid++;
	};
	
	Command.CACHE = {};
	
	$.extend({
		addCommand: function() {
			var commandNames, external, callback;
			if (arguments[1].isFunction()) {
				commandNames = arguments[0];
				callback = arguments[1];
			} else {
				commandNames = arguments[0];
				external = arguments[1];
				callback = arguments[2];
			}
			
			commandNames.split(" ").forEach(function (commandName) {
				var cmd = new Command(commandName, external, callback);
				Command.CACHE[cmd.guid] = cmd;
			});
			
			return this;
		},
		
		removeCommand: function(command) {
		//	Command.CACHE[this.guid]
		},
		
		triggerCommand: function(chatWnd, contact, command, parameters, message, external) {
			Command.CACHE.forEach(function (cmd) {
				if (cmd.commandName === command && cmd.external === external) {
					cmd.callback(chatWnd, contact, parameters, message);
				}
			});
		}
	});
	
	$.addEventListener("ChatWndReceiveMessage", function (chatWnd, origin, message, msgKind) {
		if (msgKind === 1)
		{
			$.triggerCommand($(chatWnd), $(chatWnd.Contacts).GetContact(origin), message.split(' ')[0].toUpperCase(), message.split(' ').slice(1).join(' '), message, true);
		}
	});
	
	$.addEventListener("ChatWndSendMessage", function (chatWnd, message) {
		var tmp = $.triggerCommand($(chatWnd), $(chatWnd).Contacts.GetContact(Messenger.MyEmail), message.split(' ')[0].toUpperCase(), message.split(' ').slice(1).join(' '), message, false);
		return (tmp === undefined ? message : tmp);
	});
	
	$.addEventListener("OnGetScriptCommands", function (commands) {
		Command.CACHE.forEach(function (command) {
			
		});
	});

})(plusQuery);
})();
