//////////////////////////////////////////////////////////////////////
//																	                                //
// File: MPPluginHeader.h											                      //
// Content: Messenger Plus! plugin definitions						          //
// Author: Patchou													                        //
//																	                                //
// Last Update: 2003/07/11											                    //
// Supported plugin version: 1										                  //
//																	                                //
//////////////////////////////////////////////////////////////////////
unit MPPlugin;

interface
type
  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Parameter structure used by some functions				      //
  //																	                                //
  // Members:															                            //
  //	 * iConversationWnd: Messenger Conversation Window COM			    //
  //	   interface. This pointer can be used to retrieve an			      //
  //	   IMessengerConversationWnd interface from the Messenger API.	//
  //	   Important: in some occasions, this parameter may be null.	  //
  //	   Also, you MUST NOT call Release() on this interface			    //
  //	   (Messenger Plus! will do it for you when the function		    //
  //	   returns).													                          //
  //   * sContactName. When used, this parameter indicates the		    //
  //	   friendly name of the contact who's action is the source of	  //
  //	   the call.													                          //
  //																	                                //
  //////////////////////////////////////////////////////////////////////
  PPluginParam  = ^TPluginParam;
  TPluginParam  = record
    iConversationWnd:     IDispatch;
    sContactName:         array[0..512] of Char;
  end;
  PLUGIN_PARAM  = TPluginParam;

  PPluginParamW = ^TPluginParamW;
  TPluginParamW = record
    iConversationWnd:     IDispatch;
    sContactName:         array[0..512] of WideChar;
  end;
  PLUGIN_PARAMW = TPluginParamW;


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Recognized plugin functions										                  //
  //																	                                //
  // Note: functions that end with a "W" are widechar (unicode)		    //
  // versions of the correspondent ANSI function. These methods are   //
  // called in Windows NT4/2000/XP when defined. You are not forced	  //
  // to define them; if they don't exist, Messenger Plus! will do the //
  // proper character conversions and use the ANSI functions.			    //
  //////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Initialization function									                //
  //																	                                //
  // Definition:														                          //
  //   This function is called when Messenger starts and each time a	//
  //   different user signs-in in Messenger.							            //
  //																	                                //
  // Parameters:														                          //
  //   * nVersion: plugin support version. This will be used in the	  //
  //	   future to identify different levels of support. Messenger	  //
  //	   Plus! 2.20 sets this value to 1.								              //
  //	 * sUserEmail: email of the current user in Messenger. If		    //
  //	   Messenger is not signed-in, this parameter is the email of	  //
  //	   the last user who signed in. Messenger Plus! uses this value //
  //	   to load its own settings.									                  //
  //	 * iMessengerObj: Messenger COM interface. This pointer			    //
  //	   can be used to retrieve an IMessenger3 interface from the	  //
  //	   Messenger API. For more information, consult the public		  //
  //	   Messenger API documentation on Microsoft's web site. 		    //
  //	   Important: in some occasions, this parameter may be null.	  //
  //	   Also, you MUST NOT call Release() on this interface			    //
  //	   (Messenger Plus! will do it for you during uninitialization).//
  //	 * return value: if your initialization is successfull, return  //
  //	   TRUE to notify Messenger Plus! that the plugin is ready to   //
  //	   use.															                            //
  //																	                                //
  // IMPORTANT: if this method is called in your plugin, if it		    //
  // returns TRUE but Messenger Plus! still doesn't call your other   //
  // functions, the reason is probably that it detected that your		  //
  // plugin doesn't export its functions correctly. ALL your			    //
  // functions MUST be declared with the __stdcall keyword (included  //
  // in the MPPLUGIN_RETURN_xxx defines).								              //
  //																	                                //
  //////////////////////////////////////////////////////////////////////

  {*** Implement this function ***
  function Initialize(nVersion: DWORD; sUserEmail: PChar;
                      iMessengerObj: IDispatch): BOOL; stdcall;
  }


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Uninitialization function								                //
  //																	                                //
  // Definition:														                          //
  //	 This function is called when Messenger exits or when a			    //
  //	 different user signs-in in Messenger (before Initialize() is	  //
  //	 called for the new user).										                  //
  //																	                                //
  //////////////////////////////////////////////////////////////////////
  {*** Implement this function ***
  procedure Uninitialize(); stdcall;
  }


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Inform the users about the features of the plugin		    //
  //																	                                //
  // Definition:														                          //
  //	 This function is called by Messenger Plus! to get some			    //
  //   information about the plugin. You are not forced to implement  //
  //   this function but doing so will help informing your users		  //
  //   about the features you provide (your plugin will be listed in  //
  //   the Plus! menu along with its commands and tags).				      //
  //																	                                //
  // Parameters:														                          //
  //	 * sPluginName: copy the name of your plugin in this buffer.	  //
  //	   Your plugin will be listed using this name in the Plugins	  //
  //	   menu. The maximum size for this parameter is 128 characters. //
  //   * aCommands: list of commands supported by your plugin.		    //
  //	   - nCount: number of commands you set in in the other	values. //
  //     - sName: name you want to be displayed for the command in    //
  //		 the Plugins menu.											                      //
  //	   - sValue: command string. Do NOT include "/" at the 			    //
  //		 beginning of the command. Example: "xping".				          //
  //	   - sHelp: optional help you want to be displayed when the		  //
  //		 user selects the command from the Plugins menu. This is	    //
  //		 useful only when the command accepts arguments.			        //
  //   * aTags: list of tags supported by your plugin.				        //
  //	   - nCount: number of tags you set in in the other	values.		  //
  //     - sName: name you want to be displayed for the tag in		    //
  //		 the Plugins menu.											                      //
  //	   - sValue: tag string. This parameter is the complete tag, 	  //
  //		 including the parenthesis. Remember that it is case		      //
  //		 sensitive. Example: "(!XSAMP)".							                //
  //	 * return value: if you want Messenger Plus! to display all the	//
  //	   information to the user in the Plugins menu, return TRUE,    //
  //	   else, return FALSE.											                    //
  //																	                                //
  //	Note that the commands and the tags will be listed in the order //
  //  you put them in the lists. Also, it is a good practice to add	  //
  //  a command, with the name of your plugin, that displays a		    //
  //  readme, an about box, or any other kind of help.				        //
  //																	                                //
  //////////////////////////////////////////////////////////////////////
  PPluginPublishList  = ^TPluginPublishList;
  TPluginPublishList  = record
    nCount:         Integer;
    sName:          array[0..49, 0..127] of Char;
    sValue:         array[0..49, 0..127] of Char;
    sHelp:          array[0..49, 0..255] of Char;
  end;
  PLUGIN_PUBLISH_LIST = TPluginPublishList;

  {*** Implement this function ***
  function PublishInfo(const sPluginName: PChar;
                       const aCommand, aTag: PPluginPublishList): BOOL; stdcall;
  }



  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Provide new commands in Messenger Plus!					        //
  //																	                                //
  // Definition:														                          //
  //   This function is called everytime Messenger Plus! needs its	  //
  //   plugins to analyze a command. This happens when the following	//
  //	 two conditions are met:										                    //
  //		* the user entered a message and chose to send it			        //
  //		* the message begins by "/x". Commands defined by plugins	    //
  //		  must begin with an "x" (and a command always begins by a    //
  //		  "/").														                            //
  //																	                                //
  // Parameters:														                          //
  //	 * sCommand: the command entered by the user, including the "/" //
  //	   character. Note that commands are not case sensitive.		    //
  //   * sCommandArg: all the text that followed the space after the	//
  //	   command.														                          //
  //	 * pParam: additional information sent by Messenger Plus!. For  //
  //	   more information, read the documentation of the PLUGIN_PARAM //
  //	   structure. iConversationWnd is used.							            //
  //	 * sResult: if you recognize the command passed in sCommand,	  //
  //	   you must copy the new text to send in this parameter. If		  //
  //	   you copy an empty string, the text will be ignored and won't //
  //	   be sent on the network. Important: the size of this buffer   //
  //	   is 2048 characters and it is YOUR responsability to verify	  //
  //	   that you don't write more characters to avoid memory faults. //
  //	   In any case, no more than 1100 characters will be sent on	  //
  //	   the network.													                        //
  //	 * return value: if you recognized the command and filled the   //
  //	   sResult buffer, return TRUE, else, return FALSE.				      //
  //																	                                //
  // Example:															                            //
  //	 The user sends the following text: "/xquote hello you".		    //
  //	 sCommand = "/xquote"											                      //
  //	 sCommandArg = "hello you"										                  //
  //	 You could return in sResult this text: "I salute you"			    //
  //																	                                //
  // Important: keep in mind that several plugins can be installed	  //
  // and that the user sends a lot of text. If you don't support		  //
  // the command passed in parameter, you must return as fast as		  //
  // possible and without doing anything else.						            //
  //																	                                //
  //////////////////////////////////////////////////////////////////////

  {*** Implement this function ***
  function ParseCommand(const sCommand: PChar; const sCommandArg: PChar;
                        pParam: PPluginParam; sResult: PChar): BOOL; stdcall;
  }


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Provide new tags in Messenger Plus!						          //
  //																	                                //
  // Definition:														                          //
  //   This function is called everytime Messenger Plus! needs its	  //
  //   plugins to analyze a tag. This happens when the following two	//
  //	 conditions are met:											                      //
  //		* the user entered a message and chose to send it			        //
  //		* the message contains a tag that begins by "x" or "X". A	    //
  //		  tag is always formatted this way: "(!tag)", is case		      //
  //		  sensitive and doesn't contain space characters. So plugin   //
  //		  tags must look like "(!xtag)" (where "tag" can be			      //
  //		  anything you want).										                      //
  //																	                                //
  // Parameters:														                          //
  //	 * sTag: the tag entered by the user, containing the			      //
  //	   parenthesis.													                        //
  //	 * pParam: additional information sent by Messenger Plus!. For  //
  //	   more information, read the documentation of the PLUGIN_PARAM //
  //	   structure. iConversationWnd is used.							            //
  //	 * sResult: if you recognize the tag passed in sTag, you	      //
  //	   must copy the text that will replace the tag in this			    //
  //	   parameter. Important: the size of this buffer is 2048		    //
  //	   characters and it is YOUR responsability to verify that you	//
  //	   don't write more characters to avoid memory faults. In any	  //
  //	   case, no more than 1100 characters will be sent on the		    //
  //	   network, even if the original text contained several tags	  //
  //	   using, for example, 500 characters each.						          //
  //	 * return value: if you recognized the tag and filled the		    //
  //	   sResult buffer, return TRUE, else, return FALSE.				      //
  //																	                                //
  // Example:															                            //
  //	 The user sends the following text: "my horoscope: (!XH)".		  //
  //	 sTag = "(!XH)"													                        //
  //	 You could return in sResult this text: "you'll meet somone		  //
  //		today" and text sent on the network will be "my horoscope: 	  //
  //		you'll meet someone today".									                  //
  //																	                                //
  // Important: keep in mind that several plugins can be installed	  //
  // and that the user sends a lot of text. If you don't support		  //
  // the tag passed in parameter, you must return as fast as			    //
  // possible and without doing anything else.						            //
  //																	                                //
  //////////////////////////////////////////////////////////////////////

  {*** Implement this function ****
  function ParseTag(const sTag: PChar; const pParam: PPluginParam;
                    const sResult: PChar): BOOL; stdcall;
  }


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Purpose: Allow special actions when a plugin text is received	  //
  //																	                                //
  // Definition:														                          //
  //   This function is called everytime Messenger Plus! detects a	  //
  //   plugin text ID in a message received from a user. This ID is	  //
  //	 generally placed at the beginning of a text by a plugin		    //
  //	 command to perform an action on the destination computers.		  //
  //	 This can be used, for example, to play a sound. See the		    //
  //	 control characters section for more information.				        //
  //																	                                //
  // Parameters:														                          //
  //	 * sNotifyCode: this 5 character string is the notify code that //
  //	   was sent next to the plugin ID control character. Use it to  //
  //	   identify what action to perform.								              //
  //	 * sText: the rest of the received message. You can use it to	  //
  //	   get more information about the action you want to perform.	  //
  //	   However, you MUST NOT use this parameter to determine if an  //
  //	   action is supported by your plugin. Use sNotifyCode instead. //
  //	 * pParam: additional information sent by Messenger Plus!. For  //
  //	   more information, read the documentation of the PLUGIN_PARAM //
  //	   structure. iConversationWnd and sContactName are used.		    //
  //	 * sTextToSend: this parameter is optional. You can use it if	  //
  //	   you want to ask Messenger Plus! to send a new message after  //
  //	   this one has been displayed. This WON'T modify the message	  //
  //	   associated with the notify code, this will simply send a new //
  //	   one. Important: the size of this buffer is 2048 characters	  //
  //	   and it is YOUR responsability to verify that you don't write //
  //	   more characters to avoid memory faults. In any case, no more //
  //	   than 1100 characters will be sent on the network.			      //
  //	 * return value: if you recognized the notify code return TRUE, //
  //	   else, return FALSE.											                    //
  //																	                                //
  // Important: keep in mind that several plugins can be installed	  //
  // and that a lot of text is received. If you don't support the		  //
  // notify code passed in parameter, you must return as fast as		  //
  // possible and without doing anything else.						            //
  //																	                                //
  //////////////////////////////////////////////////////////////////////

  {*** Implement this function ****
  function ReceiveNotify(const sNotifyCode: PChar; const sText: PChar;
                         const pParam: PPluginParam;
                         const sTextToSend: PChar): BOOL; stdcall;
  }


const
  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // Messenger Plus! control characters								                //
  //																	                                //
  //////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // The Notify control character is for exclusive use by plugins. It //
  // is generally inserted by plugin commands. This code must be at	  //
  // the beginning of a message and must be followed by a 5			      //
  // characters notify code unique to your plugin.					          //
  //																	                                //
  // Example: "9samplHello!" (where "9" is the 0x09 character)		    //
  // When received, the user will only see "Hello!" and				        //
  // ReceiveNotify() will be called with "sampl" in sNotifyCode.		  //
  //																	                                //
  //////////////////////////////////////////////////////////////////////
  sCCNotify     = #$12;


  //////////////////////////////////////////////////////////////////////
  //																	                                //
  // These control characters are used by Messenger Plus! to perform  //
  // different kind of actions. Feel free to use them in your own		  //
  // messages.														                            //
  //																	                                //
  //////////////////////////////////////////////////////////////////////
  sCCColor		  = #$03; //Ctrl+K multi-format
  sCCBold			  = #$02; //Ctrl+B multi-format
  sCCItalic		  = #$05; //Ctrl+T multi-format
  sCCUnderline  = #$1F; //Ctrl+U multi-format
  sCCStrikeout	= #$06; //Ctrl+S multi-format
  sCCReset		  = #$0F; //Ctrl+O multi-format

  //When placed at the beginning of a message, this control character
  //asks Messenger Plus! to temporary disable emoticons for the
  //message.
  sCCNoIcon		  = #$08;

  //To display action message (/me), put these control characters at
  //the beginning and at the end of your message.
  sCCMeStart		= 'I ';
  sCCMeEnd		  = '';

implementation

end.
