/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * darktempler@gmail.com wrote this file. As long as you retain this notice you
 * can do whatever you want with my code. If we meet some day, and you think
 * this code is worth it, you can buy me a beer in return - Matt Labrum (-dt-)
 * ----------------------------------------------------------------------------
 */ 

 /* 
	$LastChangedBy$
	$LastChangedDate$
	$LastChangedRevision$
	$HeadURL$
*/


function getWindowText(hwnd){
	var y = Interop.Allocate(512);
	Interop.Call("User32", "GetWindowTextW", hwnd, y, 512);
	return y.readString(0);
}


var lastFMPlayerHwnd = false;


//called when class is started
function Lastfm(){}

 
 
Lastfm.prototype = {
	"open" : false,
	//return state of current player, true = open, false = closed
	"isOpen" : function(){
		//the last.fm player is normally always open, so we have to check if the window is open AND if the tooltip is in songmode
		
		if(!lastFMPlayerHwnd || (getWindowText(lastFMPlayerHwnd) == "")){
			lastFMPlayerHwnd= this._findLastFmMainWindow();
		}
		
		if(lastFMPlayerHwnd !== 0 && getWindowText(lastFMPlayerHwnd) !== "Last.fm"){
				return true;
		}

		return false;
	},

	"_findLastFmMainWindow" : function(){
		var listOfBad = /LastFM|LastFMHelper|Options|Recommend/;
		var hwnd = 0;
		do{
			hwnd = Interop.Call('User32', 'FindWindowExW', 0, hwnd, 'QWidget', 0);
			if(hwnd){
				var text = getWindowText(hwnd)
				if(!text.match(listOfBad)){
					Debug.Trace("found: " + text);
					return hwnd;
				}
			}
 
		}while(hwnd !== 0);
		return false;
	},



	"Play" : function(){

	},
	
	"Pause" : function(){

	},
	
	"Stop" : function(){

	},
	
	"Next" : function(){

	},
	
	"Prev" : function(){

	},
	
	"GotoInSong" : function(milliseconds){

	},
	
	"setVolume" : function(num){
		//num is a value between 0 - 255

	},
	
	"PlaylistLength" : function(){

	},
	
	"PlaylistPosition" : function(){

	},
	
	
	/*
		for status of player return these 
		Playing = 1
		Paused = 3
		anything else = stopped
	*/
	"Status" : function(){
		return 1;
	},
	
	
	/*
	
	*/
	"SongPosition" : function(format){
		if(typeof(format) != 'undefined' && format){
			//return value in a formatted value eg, 1:05
		}else{
			//return the value in seconds
		}
	},
	
	"SongLength" : function(format){
		if(typeof(format) != 'undefined' && format){
			//return value in a formatted value eg, 1:05
		}else{
			//return the value in seconds
		}
	},
	
	
	//return the  filename of the current song 
	"CurrentFilename" : function(){
		return false;
	},
	

	/*
		return an object with song Title and Artist
		
		eg
		
		return {"Title" : "penny lane", "Artist" : "the beatles"}
		
	*/
	"CurrentTrack" : function(){
		var tip = getWindowText(lastFMPlayerHwnd).replace(/\|.+$/, "").split("  ");

		return {"Title": tip[1], 'Artist' : tip[0]};
	},

	
	"getAlbum" : function(){
		
	},
	
	"getBitrate" : function(){
		
	},
	
	"getYear" : function(){
	
	},
	
	"getSampleRate" : function(){
		
	},
	
	
	/*
		useful function to convert seconds to a formatted minutes/seconds time
	*/
	"toMinutes" : function(posSec){

		if(posSec > 60){
			var min = Math.floor(posSec / 60);
			var sec = Math.floor(posSec % 60) // :D go the division remainder operator
			if(min < 10)min = '0' + min;
			if(sec < 10)sec = '0' + sec;
			return min + ':' + sec;
		}else{
			if(posSec < 10)posSec = '0' + posSec;
			return '00:' + posSec; 
		}
	
	},
	
	//called when this class is unloaded
	"__destruct" : function(){
		
		
	}
	

		

}

/*
	below are event listeners used to add commands for your class
*/
if(typeof(addEventListener) !="undefined"){
	//register for a custom command
	addEventListener("OnEvent_ChatWndSendMessage", "_Lastfm_", function(wnd, message, ob){
		if(message == "/lnp"){
			ob.text = sendCurrentSong('Lastfm');
		}
	});

	//show the command helper for that command
	addEventListener("OnGetScriptCommands", "_Lastfm_", function(commands){
		commands.push({
			"Name" : "lnp",
			"Description" : "Displays Lastfm's current song",
			"Parameters" : ""
		});
	});
}